local iIndex = Var("GameCommand"):GetIndex();
local sName = Var("GameCommand"):GetName();
local sGameName = GAMESTATE:GetCurrentGame():GetName();

-- we need to check who joined first.
local masterPlayerNum = GAMESTATE:GetMasterPlayerNumber();

local t = Def.ActorFrame{
	Name="Item"..iIndex;
	InitCommand=cmd(fov,45);
	
	OffFocusedCommand=cmd(linear,0.2;y,SCREEN_CENTER_Y);
	OffUnfocusedCommand=cmd(runcommandsonleaves,cmd(linear,0.2;diffusealpha,0));
	
	LoadActor( THEME:GetPathB("","_frame 3x3"), "_rounded blackinset normal", SCREEN_WIDTH*0.625, 64)..{
		Name="BGFrame";
		GainFocusCommand=cmd(finishtweening;linear,0.2;diffuse,color("1,1,1,1"));
		LoseFocusCommand=cmd(linear,0.2;diffuse,color("0.5,0.5,0.5,1"););
	};
	
	LoadFont("_frutiger lt std 55 roman 24px")..{
		Name="StyleName"..iIndex;
		Text=sName;
		InitCommand=cmd(x,-100;y,-10;horizalign,left;shadowlength,0);
		GainFocusCommand=cmd(finishtweening;linear,0.2;diffuse,1,1,1,1;);
		LoseFocusCommand=cmd(linear,0.2;diffuse,0.5,0.5,0.5,1;);
	};
	LoadFont("_frutiger lt std 55 roman 24px")..{
		Name="StyleDesc"..iIndex;
		Text=THEME:GetString(Var 'LoadingScreen',sName.."-"..sGameName);
		InitCommand=cmd(x,-100;y,10;horizalign,left;shadowlength,0;zoom,0.8);
		GainFocusCommand=cmd(finishtweening;linear,0.2;diffuse,1,1,1,1;);
		LoseFocusCommand=cmd(linear,0.2;diffuse,0.5,0.5,0.5,1;);
	};
};

local pad = "";
if masterPlayerNum == PLAYER_1 then pad = "p1"
else pad = "p2";
end;

local padGainFocusCmd = cmd(finishtweening;glowshift;effectcolor1,1,1,1,0;effectcolor2,1,1,1,0.5);
local padLoseFocusCmd = cmd(stopeffect);

-- check the style here so we can see what to add

if(sName == "Single") then
	t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
		Name="PadSingle"..pad;
		InitCommand=cmd(x,-SCREEN_WIDTH/3.95;zoom,0.2;rotationx,45;diffuse,PlayerColor(masterPlayerNum););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
elseif(sName == "Versus") then
	t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
		Name="PadVersusP1";
		InitCommand=cmd(x,-SCREEN_WIDTH/3.95;zoom,0.2;rotationx,45;diffuse,PlayerColor(PLAYER_1););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
	t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
		Name="PadVersusP2";
		InitCommand=cmd(x,SCREEN_WIDTH/3.95;zoom,0.2;rotationx,45;diffuse,PlayerColor(PLAYER_2););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
elseif(sName == "Double") then
	t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
		Name="PadDouble1";
		InitCommand=cmd(x,-SCREEN_WIDTH/3.95;zoom,0.2;rotationx,45;diffuse,PlayerColor(masterPlayerNum););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
	t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
		Name="PadDouble2";
		InitCommand=cmd(x,SCREEN_WIDTH/3.95;zoom,0.2;rotationx,45;diffuse,PlayerColor(masterPlayerNum););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
end;

return t;